
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "global_draw_rect.hh"


void global_clear_rect(panel* p, color c, point corner1, point corner2)
{
  if(corner1.x<0)             corner1.x = 0;
  if(corner1.x>=p->width)     corner1.x = p->width-1;
  if(corner1.y<0)             corner1.y = 0;
  if(corner1.y>=p->height)    corner1.y = p->height-1;
  
  if(corner2.x<0)             corner2.x = 0;
  if(corner2.x>=p->width)     corner2.x = p->width-1;
  if(corner2.y<0)             corner2.y = 0;
  if(corner2.y>=p->height)    corner2.y = p->height-1;

  if(corner1.x>corner2.x)
    {
      int t = corner1.x;
      corner1.x = corner2.x;
      corner2.x = t;
    }
  
  if(corner1.y>corner2.y)
    {
      int t = corner1.y;
      corner1.y = corner2.y;
      corner2.y = t;
    }

  for(int i=corner1.x; i<=corner2.x; i++)
    for(int j=corner1.y; j<=corner2.y; j++)
      {
	p->draw_point_no_boundscheck(point(i,j), c);
      }    
}



