
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "hotspot.hh"

bool draw_hotspots = false;
struct timeval unhandled_button_press_event_time;

hotspot::hotspot(hotfunc*  event_handling_function,
		 void*     data,
		 bool      draw_this_hotspot)
  : window(BLACK)
{
  this->event_handling_function  = event_handling_function;
  this->data                     = data;
  this->draw_this_hotspot        = draw_this_hotspot;
  window_subject_to_layout = false;
}


hotspot::~hotspot()
{
}

void hotspot::draw_static(panel* p)
{
}


void hotspot::draw_dynamic()
{
  if(draw_hotspots && draw_this_hotspot)
    {
      point tl(       0,        0);
      point tr( width-1,        0);
      point bl(       0, height-1);
      point br( width-1, height-1);
      draw_line(tl, tr, GREEN);
      draw_line(tl, bl, GREEN);
      draw_line(tr, br, GREEN);
      draw_line(bl, br, GREEN);
    }
}


void hotspot::draw_dirty()
{
}


bool hotspot::handle_event(my_event& me)
{
  return event_handling_function(this, me, data);
}
