
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>

// struct dirent {
//   ino_t          d_ino;       /* Inode number */
//   off_t          d_off;       /* Not an offset; see below */
//   unsigned short d_reclen;    /* Length of this record */
//   unsigned char  d_type;      /* Type of file; not supported
//                                  by all filesystem types */
//   char           d_name[256]; /* Null-terminated filename */
// };


bool strings_match_to_length_of_first(const char* s1, const char* s2)
{
  while(*s1 && *s1==*s2)
    {
      s1++;
      s2++;
    }

  if(!*s1)
    return true;

  return false;
}

int main()
{
  DIR* dp = opendir("/dev/input");

  if(!dp)
    {
      printf("Can't search directory \"/dev/input\".\n");
      exit(20);
    }

  printf("Event files:\n\n");
  
  for(;;)
    {
      dirent *de = readdir(dp);

      if(!de)
        break;

      if(strings_match_to_length_of_first("event", de->d_name))
        {
          printf("  %s\n", de->d_name);
        }
    }

  printf("\nEnd of event files.\n");
  
  return 0;
}
