
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#ifndef TOUCH_STATE_HH
#define TOUCH_STATE_HH

#include <linux/input.h>

struct touch_slot
{
  int  tracking_id;   // Set to -1 if this slot is inactive
  int  x;
  int  y;
  bool x_valid;
  bool y_valid;

  touch_slot()  { tracking_id = -1; x = 0; y = 0; x_valid = false; y_valid = false; }
  ~touch_slot() {}
};

struct touch_state
{
  const static int      TOUCH_STATE_MAX_SLOTS   = 32;

  int                   current_slot;
  int                   num_touches;
  touch_slot            slot[TOUCH_STATE_MAX_SLOTS];

  bool                  syn_dropped;

  bool                  debug;
  
  //
  // Returns true if the event is a sync, so that
  // we have reached a valid reportable state.
  //
  bool handle_touch_event(input_event& ie);

  void print_touch_state();
  
  touch_state();

  ~touch_state() {}
};

#endif
