
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "libkiosk.hh"

#include "hotspot_demo.hh"
#include "button_demo.hh"
#include "selection_demo.hh"
#include "number_box_demo.hh"
#include "multiselect_demo.hh"
#include "select_one_demo.hh"
#include "languages.hh"
#include "graph_1.hh"
#include "graph_2.hh"
#include "intro.hh"
#include "input_demo.hh"

#include <string.h>
#include <locale.h>
#include "demo_app.hh"

void graph2_select_function(int number, menu* m, menu_item* mi, void* data)
{
  //printf("In graph2_select_function.\n");
  switch_to_graph_2((displays*) data);
}


int main(int argc, char** argv)
{
  if(argc==2)
    {
      if(!strcmp(argv[1], "-nodisplay"))
	{
	  printf("Preventing display output (web output only).  For testing.\n");
	  enable_display = false;
	}
      else
	{
	  printf("Unknown argument \"%s\".  Try \"-nodisplay\".\n", argv[1]);
	  exit(20);
	}
    }
  else if(argc!=1)
    {
      printf("Too many arguments.\n");
      exit(20);
    }

  //
  // Create the display asap after main() starts.  It forks off multiple
  // processes and threads to manage this and that, and it's best to do this
  // early.
  //
  displays* d = new displays(NUM_PANES);

  menu* menu_main               = new menu();
  menu_item* mi_intro           = new menu_item();
  menu_item* mi_graph_demo_1    = new menu_item();
  menu_item* mi_graph_demo_2    = new menu_item();
  menu_item* mi_input_demo      = new menu_item();
  menu_item* mi_control_demo    = new menu_item();
  //menu_item* mi_configuration   = new menu_item();

  mi_intro->set_name(U"Intro", ENGLISH);
  mi_intro->set_name(U"介绍", CHINESE_SIMPLE);
  mi_intro->set_name(U"介紹", CHINESE);
  mi_intro->set_name(U"परिचय", HINDI);
  mi_intro->set_name(U"Introducción", SPANISH);
  mi_intro->set_name(U"Introduction", FRENCH);
  mi_intro->set_name(U"مقدمة", ARABIC);
  mi_intro->set_name(U"ভূমিকা", BENGALI);
  mi_intro->set_name(U"Вступ", UKRANIAN);
  mi_intro->set_name(U"Introdução", PORTUGUESE);
  mi_intro->set_name(U"تعارف", URDU);
  mi_intro->set_name(U"Perkenalan", INDONESIAN);
  mi_intro->set_name(U"Einführung", GERMAN);
  mi_intro->set_name(U"導入", JAPANESE);
  mi_intro->set_name(U"Εισαγωγή", GREEK);
  mi_intro->set_name(U"Introduzione", ITALIAN);
  mi_intro->set_name(U"Вступление", RUSSIAN);
  mi_intro->set_name(U"מָבוֹא", HEBREW);
  
  mi_graph_demo_1->set_name(U"Graph Demo 1", ENGLISH);
  mi_graph_demo_1->set_name(U"图表演示 1", CHINESE_SIMPLE);
  mi_graph_demo_1->set_name(U"圖表示範 1", CHINESE);
  mi_graph_demo_1->set_name(U"ग्राफ़ डेमो 1", HINDI);
  mi_graph_demo_1->set_name(U"Demo gráfica 1", SPANISH);
  mi_graph_demo_1->set_name(U"GraphiqueDémo 1", FRENCH);
  mi_graph_demo_1->set_name(U"عرض الرسم البياني 1", ARABIC);
  mi_graph_demo_1->set_name(U"গ্রাফ ডেমো ১", BENGALI);
  mi_graph_demo_1->set_name(U"Демо графіка 1", UKRANIAN);
  mi_graph_demo_1->set_name(U"Demo gráfica 1", PORTUGUESE);
  mi_graph_demo_1->set_name(U"گراف ڈیمو 1", URDU);
  mi_graph_demo_1->set_name(U"Demo Grafik 1", INDONESIAN);
  mi_graph_demo_1->set_name(U"Graph-Demo 1", GERMAN);
  mi_graph_demo_1->set_name(U"グラフデモ1", JAPANESE);
  mi_graph_demo_1->set_name(U"Επίδειξη Γραφήματος 1", GREEK);
  mi_graph_demo_1->set_name(U"Demo grafico 1", ITALIAN);
  mi_graph_demo_1->set_name(U"Демо графика 1", RUSSIAN);
  mi_graph_demo_1->set_name("1" "הדגמת גרף", HEBREW);

  mi_graph_demo_2->set_name(U"Graph Demo 2", ENGLISH);
  mi_graph_demo_2->set_name(U"图表演示 2", CHINESE_SIMPLE);
  mi_graph_demo_2->set_name(U"圖表示範 2", CHINESE);
  mi_graph_demo_2->set_name(U"ग्राफ़ डेमो 2", HINDI);
  mi_graph_demo_2->set_name(U"Demo gráfica 2", SPANISH);
  mi_graph_demo_2->set_name(U"GraphiqueDémo 2", FRENCH);
  mi_graph_demo_2->set_name(U"عرض الرسم البياني 2", ARABIC);
  mi_graph_demo_2->set_name(U"গ্রাফ ডেমো ২", BENGALI);
  mi_graph_demo_2->set_name(U"Демо графіка 2", UKRANIAN);
  mi_graph_demo_2->set_name(U"Demo gráfica 2", PORTUGUESE);
  mi_graph_demo_2->set_name(U"گراف ڈیمو 2", URDU);
  mi_graph_demo_2->set_name(U"Demo Grafik 2", INDONESIAN);
  mi_graph_demo_2->set_name(U"Graph-Demo 2", GERMAN);
  mi_graph_demo_2->set_name(U"グラフデモ2", JAPANESE);
  mi_graph_demo_2->set_name(U"Επίδειξη Γραφήματος 2", GREEK);
  mi_graph_demo_2->set_name(U"Demo grafico 2", ITALIAN);
  mi_graph_demo_2->set_name(U"Демо графика 2", RUSSIAN);
  mi_graph_demo_2->set_name("2" "הדגמת גרף", HEBREW);

  mi_graph_demo_2->set_function(graph2_select_function, (void*)d);

  mi_input_demo->set_name(U"Input Demo", ENGLISH);
  mi_input_demo->set_name(U"输入演示", CHINESE_SIMPLE);
  mi_input_demo->set_name(U"輸入演示", CHINESE);
  mi_input_demo->set_name(U"इनपुट डेमो", HINDI);
  mi_input_demo->set_name(U"Entrada", SPANISH);
  mi_input_demo->set_name(U"Démo d'entrée", FRENCH);
  mi_input_demo->set_name(U"عرض الإدخال التجريبي", ARABIC);
  mi_input_demo->set_name(U"ইনপুট ডেমো", BENGALI);
  mi_input_demo->set_name(U"Демо введення", UKRANIAN);
  mi_input_demo->set_name(U"Entrada", PORTUGUESE);
  mi_input_demo->set_name(U"ان پٹ ڈیمو", URDU);
  mi_input_demo->set_name(U"Demo Masukan", INDONESIAN);
  mi_input_demo->set_name(U"Eingabedemo", GERMAN);
  mi_input_demo->set_name(U"入力デモ", JAPANESE);
  mi_input_demo->set_name(U"Επίδειξη εισαγωγής", GREEK);
  mi_input_demo->set_name(U"Demo di input", ITALIAN);
  mi_input_demo->set_name(U"Демо ввода", RUSSIAN);
  mi_input_demo->set_name(U"הדגמת קלט", HEBREW);

  mi_control_demo->set_name(U"Controls Demo", ENGLISH);
  mi_control_demo->set_name(U"控制演示", CHINESE_SIMPLE);
  mi_control_demo->set_name(U"控制演示", CHINESE);
  mi_control_demo->set_name(U"नियंत्रण डेमो", HINDI);
  mi_control_demo->set_name(U"Controles", SPANISH);
  mi_control_demo->set_name(U"Commandes", FRENCH);
  mi_control_demo->set_name(U"عناصر التحكم التجريبية", ARABIC);
  mi_control_demo->set_name(U"নিয়ন্ত্রণ ডেমো", BENGALI);
  mi_control_demo->set_name(U"Демо керування", UKRANIAN);
  mi_control_demo->set_name(U"Controlos", PORTUGUESE);
  mi_control_demo->set_name(U"ڈیمو کو کنٹرول کرتا ہے۔", URDU);
  mi_control_demo->set_name(U"Demo Kontrol", INDONESIAN);
  mi_control_demo->set_name(U"Steuerungsdemo", GERMAN);
  mi_control_demo->set_name(U"コントロールデモ", JAPANESE);
  mi_control_demo->set_name(U"Επίδειξη ελέγχου", GREEK);
  mi_control_demo->set_name(U"Demo dei controlli", ITALIAN);
  mi_control_demo->set_name(U"Демо управления", RUSSIAN);
  mi_control_demo->set_name(U"הדגמת בקרות", HEBREW);

#ifdef NOTDEF
  mi_configuration->set_name(U"Configuration", ENGLISH);
  mi_configuration->set_name(U"配置", CHINESE_SIMPLE);
  mi_configuration->set_name(U"配置", CHINESE);
  mi_configuration->set_name(U"विन्यास", HINDI);
  mi_configuration->set_name(U"Configuración", SPANISH);
  mi_configuration->set_name(U"Configuration", FRENCH);
  mi_configuration->set_name(U"إعدادات", ARABIC);
  mi_configuration->set_name(U"কনফিগারেশন", BENGALI);
  mi_configuration->set_name(U"Конфігурація", UKRANIAN);
  mi_configuration->set_name(U"Configuração", PORTUGUESE);
  mi_configuration->set_name(U"کنفیگریشن", URDU);
  mi_configuration->set_name(U"Konfigurasi", INDONESIAN);
  mi_configuration->set_name(U"Konfiguration", GERMAN);
  mi_configuration->set_name(U"構成", JAPANESE);
  mi_configuration->set_name(U"Διαμόρφωση", GREEK);
  mi_configuration->set_name(U"Configurazione", ITALIAN);
  mi_configuration->set_name(U"Конфигурация", RUSSIAN);
  mi_configuration->set_name(U"תְצוּרָה", HEBREW);
#endif
  
  //menu* new_graph               = new menu_action("New Graph", new_graph_action, graph_menu);  graph_menu -> add(new_graph);
  
  //menu_action* return_to_graph  = new menu_action("Go to Graphs", menu_return_to_graph_action, graph_menu);

  menu_main->add(mi_intro);
  menu_main->add(mi_graph_demo_1);
  menu_main->add(mi_graph_demo_2);
  menu_main->add(mi_input_demo);
  menu_main->add(mi_control_demo);
  //  menu_main->add(mi_configuration);

  //intro_menu->this_selected();
  menu_main->select_a_child(0);
  
  //d->add(main, MENU_PANE);
  d->add(menu_main);

  setup_graph_2(d);

  intro* intro_window = setup_intro();

  select_one* sel1 = setup_language_select();
  select_one* sel2 = setup_decimal_select();

  multiwindow* mi_language_mw = new multiwindow;
  mi_language_mw->change_layout(new vertical_layout_plan);

  mi_language_mw->add(sel2);
  mi_language_mw->add(sel1);
  
  multiwindow* mi_intro_mw = new multiwindow;
  mi_intro_mw->change_layout(new horizontal_layout_plan);

  mi_intro_mw->add(mi_language_mw);
  mi_intro_mw->add(intro_window);

  mi_intro->add(mi_intro_mw);


  //d->add(intro_window);
  //mi_graph_demo_1->add(sel1);
  //mi_graph_demo_1->add(intro_window);
    
  graph* gr = setup_graph_1();

  //d->add(gr);
  mi_graph_demo_1->add(gr);


  window* input_demo = create_input_demo_window();

  mi_input_demo->add(input_demo);

  //switch_to_graph_2(d);

  menu* menu_controls               = new menu();

  menu_item* mi_hotspot             = new menu_item();
  menu_item* mi_button              = new menu_item();
  menu_item* mi_selection           = new menu_item();
  menu_item* mi_number_box          = new menu_item();
  menu_item* mi_select_one          = new menu_item();
  menu_item* mi_multiselect         = new menu_item();

  mi_control_demo->add(menu_controls);

  menu_controls->add(mi_hotspot);
  menu_controls->add(mi_button);
  menu_controls->add(mi_number_box);
  menu_controls->add(mi_selection);
  menu_controls->add(mi_select_one);
  menu_controls->add(mi_multiselect);

  mi_hotspot->set_name(U"Hotspot", ENGLISH);
  mi_hotspot->set_name(U"热点", CHINESE_SIMPLE);
  mi_hotspot->set_name(U"熱點", CHINESE);
  mi_hotspot->set_name(U"हॉटस्पॉट", HINDI);
  mi_hotspot->set_name(U"Punto de acceso", SPANISH);
  mi_hotspot->set_name(U"Point chaud", FRENCH);
  mi_hotspot->set_name(U"نقطة اتصال", ARABIC);
  mi_hotspot->set_name(U"হটস্পট", BENGALI);
  mi_hotspot->set_name(U"Гаряча точка", UKRANIAN);
  mi_hotspot->set_name(U"Ponto de acesso", PORTUGUESE);
  mi_hotspot->set_name(U"ہاٹ سپاٹ", URDU);
  mi_hotspot->set_name(U"Titik panas", INDONESIAN);
  mi_hotspot->set_name(U"Hotspot", GERMAN);
  mi_hotspot->set_name(U"ホットスポット", JAPANESE);
  mi_hotspot->set_name(U"Hotspot", GREEK);
  mi_hotspot->set_name(U"Punto di accesso", ITALIAN);
  mi_hotspot->set_name(U"Горячая точка", RUSSIAN);
  mi_hotspot->set_name(U"נקודה חמה", HEBREW);

  mi_button->set_name(U"Button", ENGLISH);
  mi_button->set_name(U"按钮开关", CHINESE_SIMPLE);
  mi_button->set_name(U"按鈕開關", CHINESE);
  mi_button->set_name(U"बटन", HINDI);
  mi_button->set_name(U"botón", SPANISH);
  mi_button->set_name(U"bouton", FRENCH);
  mi_button->set_name(U"زر", ARABIC);
  mi_button->set_name(U"বোতাম", BENGALI);
  mi_button->set_name(U"кнопка", UKRANIAN);
  mi_button->set_name(U"botão", PORTUGUESE);
  mi_button->set_name(U"بٹن", URDU);
  mi_button->set_name(U"tombol", INDONESIAN);
  mi_button->set_name(U"Knopf", GERMAN);
  mi_button->set_name(U"ボタン", JAPANESE);
  mi_button->set_name(U"Κουμπί", GREEK);
  mi_button->set_name(U"Pulsante", ITALIAN);
  mi_button->set_name(U"кнопочный", RUSSIAN);
  mi_button->set_name(U"כַּפתוֹר", HEBREW);

  mi_selection->set_name(U"Ask Selection", ENGLISH);
  mi_selection->set_name(U"询问选择", CHINESE_SIMPLE);
  mi_selection->set_name(U"詢問選擇", CHINESE);
  mi_selection->set_name(U"चयन पूछें", HINDI);
  mi_selection->set_name(U"Preguntar selección", SPANISH);
  mi_selection->set_name(U"Demander la sélection", FRENCH);
  mi_selection->set_name(U"اطلب التحديد", ARABIC);
  mi_selection->set_name(U"নির্বাচন জিজ্ঞাসা করুন", BENGALI);
  mi_selection->set_name(U"Запитайте про вибір", UKRANIAN);
  mi_selection->set_name(U"Solicitar seleção", PORTUGUESE);
  mi_selection->set_name(U"انتخاب سے پوچھیں۔", URDU);
  mi_selection->set_name(U"Tanyakan Pilihan", INDONESIAN);
  mi_selection->set_name(U"Auswahl anfragen", GERMAN);
  mi_selection->set_name(U"選択を依頼する", JAPANESE);
  mi_selection->set_name(U"Ρωτήστε για την επιλογή", GREEK);
  mi_selection->set_name(U"Chiedi selezione", ITALIAN);
  mi_selection->set_name(U"Запросить выбор", RUSSIAN);
  mi_selection->set_name(U"שאל את הבחירה", HEBREW);

  mi_number_box->set_name(U"Number Box", ENGLISH);
  mi_number_box->set_name(U"数字框", CHINESE_SIMPLE);
  mi_number_box->set_name(U"數位箱", CHINESE);
  mi_number_box->set_name(U"नंबर बॉक्स", HINDI);
  mi_number_box->set_name(U"Caja de números", SPANISH);
  mi_number_box->set_name(U"Boîte à numéros", FRENCH);
  mi_number_box->set_name(U"صندوق الأرقام", ARABIC);
  mi_number_box->set_name(U"সংখ্যা বাক্স", BENGALI);
  mi_number_box->set_name(U"Номерна коробка", UKRANIAN);
  mi_number_box->set_name(U"Caixa de números", PORTUGUESE);
  mi_number_box->set_name(U"نمبر باکس", URDU);
  mi_number_box->set_name(U"Kotak Angka", INDONESIAN);
  mi_number_box->set_name(U"Zahlenfeld", GERMAN);
  mi_number_box->set_name(U"ナンバーボックス", JAPANESE);
  mi_number_box->set_name(U"Πλαίσιο αριθμών", GREEK);
  mi_number_box->set_name(U"Casella numerica", ITALIAN);
  mi_number_box->set_name(U"Числовое поле", RUSSIAN);
  mi_number_box->set_name(U"תיבת מספרים", HEBREW);

  mi_select_one->set_name(U"Select One", ENGLISH);
  mi_select_one->set_name(U"一个选择", CHINESE_SIMPLE);
  mi_select_one->set_name(U"一個選擇", CHINESE);
  mi_select_one->set_name(U"एक विकल्प", HINDI);
  mi_select_one->set_name(U"Una elección", SPANISH);
  mi_select_one->set_name(U"Un choix", FRENCH);
  mi_select_one->set_name(U"خيار واحد", ARABIC);
  mi_select_one->set_name(U"এক পছন্দ", BENGALI);
  mi_select_one->set_name(U"Один вибір", UKRANIAN);
  mi_select_one->set_name(U"Uma escolha", PORTUGUESE);
  mi_select_one->set_name(U"ون چوائس", URDU);
  mi_select_one->set_name(U"Satu Pilihan", INDONESIAN);
  mi_select_one->set_name(U"Eine Wahl", GERMAN);
  mi_select_one->set_name(U"ワンチョイス", JAPANESE);
  mi_select_one->set_name(U"Μία Επιλογή", GREEK);
  mi_select_one->set_name(U"Una scelta", ITALIAN);
  mi_select_one->set_name(U"Один выбор", RUSSIAN);
  mi_select_one->set_name(U"בחירה אחת", HEBREW);

  mi_multiselect->set_name(U"Multiselect", ENGLISH);
  mi_multiselect->set_name(U"多种选择", CHINESE_SIMPLE);
  mi_multiselect->set_name(U"多種選擇", CHINESE);
  mi_multiselect->set_name(U"कई विकल्प", HINDI);
  mi_multiselect->set_name(U"Muchas opciones", SPANISH);
  mi_multiselect->set_name(U"De nombreux choix", FRENCH);
  mi_multiselect->set_name(U"العديد من الخيارات", ARABIC);
  mi_multiselect->set_name(U"অনেক পছন্দ", BENGALI);
  mi_multiselect->set_name(U"Багато варіантів", UKRANIAN);
  mi_multiselect->set_name(U"Muitas opções", PORTUGUESE);
  mi_multiselect->set_name(U"بہت سے انتخاب", URDU);
  mi_multiselect->set_name(U"Banyak Pilihan", INDONESIAN);
  mi_multiselect->set_name(U"Viele Möglichkeiten", GERMAN);
  mi_multiselect->set_name(U"多くの選択肢", JAPANESE);
  mi_multiselect->set_name(U"Πολλές επιλογές", GREEK);
  mi_multiselect->set_name(U"Molte scelte", ITALIAN);
  mi_multiselect->set_name(U"Много вариантов", RUSSIAN);
  mi_multiselect->set_name(U"אפשרויות רבות", HEBREW);


  window* hotspot_demo = create_hotspot_demo_window();
  mi_hotspot->add(hotspot_demo);


  window* button_demo = create_button_demo_window();
  mi_button->add(button_demo);

  window* number_box_demo = create_number_box_demo_window();
  mi_number_box->add(number_box_demo);

  window* selection_demo = create_selection_demo_window();
  mi_selection->add(selection_demo);

  window* multiselect_demo = create_multiselect_demo_window();
  mi_multiselect->add(multiselect_demo);

  window* select_one_demo = create_select_one_demo_window();
  mi_select_one->add(select_one_demo);

  printf("Display ready.\n");

  sleep(1);
  printf("Touch Recognized Beep\n");
  global_touch_recognized_beep();
  sleep(1);

  //
  // This loop in this thread is responsible for drawing the next screen and for
  // processing input events between screen updates.  Once a screen is drawn, it is
  // flipped by a separate thread in time with the vertical refresh.
  //
  d->event_loop();

  printf("Incorrectly exited event_loop.\n");
  abort();

  
  return 0;
}


