
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "kiosk/runnable.hh"
#include "kiosk/graph.hh"

#include "graph_1.hh"
#include "languages.hh"

void data_update_main_1(void* data);


graph* setup_graph_1()
{
  printf("Setting up graph 1.\n");

  graph* gr = new graph;

  gr->set_label(0, U"Red Graph Label",                  ENGLISH);
  gr->set_label(0, U"红色图表标签",                     CHINESE_SIMPLE);
  gr->set_label(0, U"紅色圖表標籤",                     CHINESE);
  gr->set_label(0, U"लाल ग्राफ लेबल",                     HINDI);
  gr->set_label(0, U"Etiqueta de gráfico roja",         SPANISH);
  gr->set_label(0, U"Étiquette du graphique rouge",     FRENCH);
  gr->set_label(0, U"ملصق الرسم البياني الأحمر",             ARABIC);
  gr->set_label(0, U"লাল গ্রাফ লেবেল",                  BENGALI);
  gr->set_label(0, U"Червона мітка графіка",            UKRANIAN);
  gr->set_label(0, U"Rótulo do gráfico vermelho",       PORTUGUESE);
  gr->set_label(0, U"ریڈ گراف لیبل",                      URDU);
  gr->set_label(0, U"Label Grafik Merah",               INDONESIAN);
  gr->set_label(0, U"Rotes Diagrammetikett",            GERMAN);
  gr->set_label(0, U"赤いグラフラベル",                 JAPANESE);
  gr->set_label(0, U"Κόκκινη ετικέτα γραφήματος",       GREEK);
  gr->set_label(0, U"Etichetta del grafico rosso",      ITALIAN);
  gr->set_label(0, U"Красная метка графика",            RUSSIAN);
  gr->set_label(0, U"Красная метка графика",            RUSSIAN);
  gr->set_label(0, U"תווית גרף אדומה",                   HEBREW);

  gr->set_label(2, U"Blue Graph Label",                 ENGLISH);
  gr->set_label(2, U"蓝色图表标签",                     CHINESE_SIMPLE);
  gr->set_label(2, U"藍色圖表標籤",                     CHINESE);
  gr->set_label(2, U"नीला ग्राफ़ लेबल",                     HINDI);
  gr->set_label(2, U"Etiqueta de gráfico azul",         SPANISH);
  gr->set_label(2, U"Étiquette du graphique bleu",      FRENCH);
  gr->set_label(2, U"ملصق الرسم البياني الأزرق",             ARABIC);
  gr->set_label(2, U"নীল গ্রাফ লেবেল",                   BENGALI);
  gr->set_label(2, U"Синя етикетка графіка",            UKRANIAN);
  gr->set_label(2, U"Rótulo de gráfico azul",           PORTUGUESE);
  gr->set_label(2, U"بلیو گراف لیبل",                      URDU);
  gr->set_label(2, U"Label Grafik Biru",                INDONESIAN);
  gr->set_label(2, U"Blaues Diagrammetikett",           GERMAN);
  gr->set_label(2, U"ブルーグラフラベル",               JAPANESE);
  gr->set_label(2, U"Μπλε ετικέτα γραφήματος",          GREEK);
  gr->set_label(2, U"Etichetta del grafico blu",        ITALIAN);
  gr->set_label(2, U"Синяя графическая метка",          RUSSIAN);
  gr->set_label(2, U"תווית גרף כחולה",                   HEBREW);

  gr->set_x_axis_title(U"X Axis",    ENGLISH);
  gr->set_x_axis_title(U"X轴",       CHINESE_SIMPLE);
  gr->set_x_axis_title(U"X軸",       CHINESE);
  gr->set_x_axis_title(U"एक्स अक्ष",   HINDI);
  gr->set_x_axis_title(U"Eje X",     SPANISH);
  gr->set_x_axis_title(U"Axe X",     FRENCH);
  gr->set_x_axis_title(U"المحور X",   ARABIC);
  gr->set_x_axis_title(U"এক্স অক্ষ",   BENGALI);
  gr->set_x_axis_title(U"Вісь X",    UKRANIAN);
  gr->set_x_axis_title(U"Eixo X",    PORTUGUESE);
  gr->set_x_axis_title(U"ایکس محور", URDU);
  gr->set_x_axis_title(U"Sumbu X",   INDONESIAN);
  gr->set_x_axis_title(U"X-Achse",   GERMAN);
  gr->set_x_axis_title(U"X軸",       JAPANESE);
  gr->set_x_axis_title(U"Άξονας Χ",  GREEK);
  gr->set_x_axis_title(U"Asse X",    ITALIAN);
  gr->set_x_axis_title(U"Ось X",     RUSSIAN);
  gr->set_x_axis_title(U"ציר X",      HEBREW);

  gr->set_y_axis_title(U"Y Axis",    ENGLISH);
  gr->set_y_axis_title(U"Y轴",       CHINESE_SIMPLE);
  gr->set_y_axis_title(U"Y軸",       CHINESE);
  gr->set_y_axis_title(U"Y अक्ष",     HINDI);
  gr->set_y_axis_title(U"Eje Y",     SPANISH);
  gr->set_y_axis_title(U"Axe Y",     FRENCH);
  gr->set_y_axis_title(U"المحور Y",   ARABIC);
  gr->set_y_axis_title(U"Y অক্ষ",    BENGALI);
  gr->set_y_axis_title(U"Вісь Y",    UKRANIAN);
  gr->set_y_axis_title(U"Eixo Y",    PORTUGUESE);
  gr->set_y_axis_title(U"Y ایکسس",   URDU);
  gr->set_y_axis_title(U"Sumbu Y",   INDONESIAN);
  gr->set_y_axis_title(U"Y-Achse",   GERMAN);
  gr->set_y_axis_title(U"Y軸",       JAPANESE);
  gr->set_y_axis_title(U"Άξονας Y",  GREEK);
  gr->set_y_axis_title(U"Asse Y",    ITALIAN);
  gr->set_y_axis_title(U"Ось Y",     RUSSIAN);
  gr->set_y_axis_title(U"ציר Y",     HEBREW);

  gr->set_title(U"English Graph Title 😃",             ENGLISH);
  gr->set_title(U"简体中文图形标题 😃",                CHINESE_SIMPLE);
  gr->set_title(U"中文圖名 😃",                        CHINESE);
  gr->set_title(U"हिंदी ग्राफ शीर्षक 😃",                   HINDI);
  gr->set_title(U"Título del gráfico en español 😃",   SPANISH);
  gr->set_title(U"Titre du graphique en français 😃",  FRENCH);
  gr->set_title(U"عنوان الرسم البياني باللغة العربية 😃",       ARABIC);
  gr->set_title(U"বাংলা গ্রাফ শিরোনাম 😃",               BENGALI);
  gr->set_title(U"Назва українського графіка 😃",      UKRANIAN);
  gr->set_title(U"Título do gráfico em português 😃",  PORTUGUESE);
  gr->set_title(U"اردو گراف کا عنوان 😃",                 URDU);
  gr->set_title(U"Judul Grafik Bahasa Indonesia 😃",   INDONESIAN);
  gr->set_title(U"Deutscher Graphtitel 😃",            GERMAN);
  gr->set_title(U"日本語グラフタイトル 😃",            JAPANESE);
  gr->set_title(U"Τίτλος ελληνικού γραφήματος 😃",     GREEK);
  gr->set_title(U"Titolo del grafico italiano 😃",     ITALIAN);
  gr->set_title(U"Русский Граф Заголовок 😃",          RUSSIAN);
  gr->set_title(U"כותרת גרף עברי 😃",                  HEBREW);

  new runnable(data_update_main_1, gr);

  return gr;
}

double sinc(double x)
{
  if(x==0.0)
    return 1.0;
  
  return sin(x)/x;
}

void data_update_main_1(void* data)
{
  graph* gr = (graph*) data;

  int num_graph_points = 201;

  graph_data* gd1 = new graph_data(3,                         // max_datasets
				   num_graph_points,          // num_points
				   -1.0,                      // x_data_start
				   2.0/(num_graph_points-1)); // x_data_step

  graph_data* gd2 = new graph_data(3,                         // max_datasets
				   num_graph_points,          // num_points
				   -1.0,                      // x_data_start
				   2.0/(num_graph_points-1)); // x_data_step

  graph_data* gd = gd1;
  
  printf("**** Started update for graph_1\n");

  int direction = 1;

  int count = 0;
  bool show_error_text = true;
  int n = 0;
  
  for(;;)
    {
      usleep(10000);

      if(gr->ready_for_new_data())
	{

	  show_error_text = ((count%500)>400);

	  gd->num_datasets = 1 + (((count%500)>100)?1:0) + (((count%500)>200)?1:0);

	  if(count%1000==0)
	    {
	      gr->set_background_color(GREY3);
	      gr->set_title_color(WHITE);
	      gr->set_panel_color(GREY2);
	      
	      gr->set_title_font_height         (  5, 25, 1000 );
	      gr->set_axis_title_font_height    (  4, 20, 1000 );
	      gr->set_tic_label_font_height     (  3,  6, 1000 );
	      gr->set_dataset_label_font_height (  3, 15, 1000 );
	      gr->set_error_text_font_height    (  8, 25, 1000 );
	      
	      gr->mark_layout_dirty();
	    }
	  else if(count%1000==500)
	    {
	      gr->set_background_color(GREY3);
	      gr->set_title_color(BLUE8);
	      gr->set_panel_color(BLUE1);
	      
	      gr->set_title_font_height         (  4, 30, 1000 );
	      gr->set_axis_title_font_height    (  3, 25, 1000 );
	      gr->set_tic_label_font_height     (  2, 20, 1000 );
	      gr->set_dataset_label_font_height (  2, 15, 1000 );
	      gr->set_error_text_font_height    (  6, 50, 1000 );
	      
	      gr->mark_layout_dirty();
	    }
	  
	  count = (count+1)%100000;
	
	  
	  gd->x_data_start = -4;
	  float x_data_end = 5;
	  gd->x_data_step  = (x_data_end - gd->x_data_start) / (gd->num_points-1);
	  
	  if(show_error_text)
	    {
	      char32_t temp1[100];
	      char     temp2[100];
	      
	      static multilingua txt;
	      static bool init = true;
	      if(init)
		{
		  init = false;
		  txt.set_text(U"SIMULATED DATA ERROR",            ENGLISH);
		  txt.set_text(U"模拟数据错误",                    CHINESE_SIMPLE);
		  txt.set_text(U"模擬數據錯誤",                    CHINESE);
		  txt.set_text(U"नकली डेटा त्रुटि",                    HINDI);
		  txt.set_text(U"Error de datos simulados",        SPANISH);
		  txt.set_text(U"Erreur de données simulée",       FRENCH);
		  txt.set_text(U"خطأ في البيانات المحاكية",             ARABIC);
		  txt.set_text(U"সিমুলেটেড ডেটা ত্রুটি",              BENGALI);
		  txt.set_text(U"Помилка змодельованих даних",     UKRANIAN);
		  txt.set_text(U"Erro de dados simulados",         PORTUGUESE);
		  txt.set_text(U"نقلی ڈیٹا کی خرابی۔",                URDU);
		  txt.set_text(U"Kesalahan Data Simulasi",         INDONESIAN);
		  txt.set_text(U"Simulierter Datenfehler",         GERMAN);
		  txt.set_text(U"シミュレーションデータエラー",    JAPANESE);
		  txt.set_text(U"Σφάλμα προσομοίωσης δεδομένων",   GREEK);
		  txt.set_text(U"Errore dati simulato",            ITALIAN);
		  txt.set_text(U"Ошибка моделирования данных",     RUSSIAN);
		  txt.set_text(U"שגיאת נתונים מדומה",     HEBREW);
		}
	      
	      sprintf(temp2, " %d", count%1000);
	      int i=0;
	      for(;txt[i]; i++)
		temp1[i] = txt[i];
	      
	      for(int j=0;;j++)
		{
		  temp1[i+j] = temp2[j];
		  if(!temp2[j])
		    break;
		}
	  
	      gd->set_error_text(temp1);
	    }
	  else
	    {
	      gd->set_error_text(U"");
	    }
      
	  for(int i=0; i<gd->num_points; i++)
	    {
	      double x = 2.0 * i / (gd->num_points-1) - 1.0;
	      double a = sinc(10.0*x);
	      double b = x;
	      int m = (n+50)>100?150-n:n+50;
	      gd->y_data[0]->data[i] = (n*a + (100-n)*b)/100;
	      gd->y_data[1]->data[i] = (n*b + (100-n)*a)/100;
	      gd->y_data[2]->data[gd->num_points-1-i] = (m*b + (100-m)*a)/100;
	    }
	  
	  // printf("Supplied graph_data.\n");
	  gr->accept_data(gd);
      
	  if(gd==gd1)
	    gd = gd2;
	  else
	    gd = gd1;
	}
      
      if(n==0)
	direction = 1;
      else if(n==100)
	direction = -1;

      n+=direction;
    }
}
