
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "kiosk/window.hh"
#include "kiosk/multiwindow.hh"
#include "kiosk/hotspot.hh"

#include "hotspot_demo.hh"
#include "languages.hh"

class toggling_hotspot : public hotspot
{
public:
  bool draw_it;

  virtual void draw_dirty();

  toggling_hotspot(hotfunc*  event_handling_function,
		   void*     data);
  
  virtual ~toggling_hotspot() {}
};


void toggling_hotspot::draw_dirty()
{
  if(draw_it) clear(GREY7);
}

toggling_hotspot::toggling_hotspot(hotfunc*  event_handling_function,
				   void*     data)
  :  hotspot(event_handling_function, data, true)
{
  draw_it = false;
}


bool hotspot_function(hotspot* h, my_event&me, void* data)
{
  //print_event(me);
  
  bool toggle_it = false;
  if(me.source_mouse && me.type==EVENT_TOUCH && me.mouse_buttons_pressed==MOUSE_BUTTON_LEFT)
    toggle_it = true;
  else if((!me.source_mouse) && me.type==EVENT_TOUCH && me.num_touches==1)
    toggle_it = true;

  if(toggle_it)
    {
      toggling_hotspot* th = (toggling_hotspot*) h;
      th->draw_it = !th->draw_it;
      th->mark_dirty();
      return true;
    }
  return false;
}

class hotspot_demo_window : public multiwindow
{
  constexpr static int NUM_HOTSPOTS = 6;
  toggling_hotspot* th[NUM_HOTSPOTS];
  
  virtual void layout();
  virtual void draw_dirty();
  
public:
  
  hotspot_demo_window();
  ~hotspot_demo_window();
};

window* create_hotspot_demo_window()
{
  return new hotspot_demo_window();
}


hotspot_demo_window::~hotspot_demo_window()
{
  for(int i=0; i<NUM_HOTSPOTS; i++)
    if(th[i])
      delete th[i];
}

hotspot_demo_window::hotspot_demo_window()
{
  for(int i=0; i<NUM_HOTSPOTS; i++)
    th[i] = 0;
  
  th[0] = new toggling_hotspot(hotspot_function,
			       0);

  th[1] = new toggling_hotspot(hotspot_function,
			       0);

  th[2] = new toggling_hotspot(hotspot_function,
			       0);

  th[3] = new toggling_hotspot(hotspot_function,
			       0);

  th[4] = new toggling_hotspot(hotspot_function,
			       0);

  th[5] = new toggling_hotspot(hotspot_function,
			       0);

  for(int i=0; i<NUM_HOTSPOTS; i++)
    if(th[i])
      add(th[i]);
}

void hotspot_demo_window::layout()
{
  th[0]->resize(10*width/100, 10*height/100, 20*width/100, 20*height/100);
  th[1]->resize(40*width/100, 15*height/100, 40*width/100,  5*height/100);
  th[2]->resize(90*width/100, 90*height/100,  5*width/100,  5*height/100);
  th[3]->resize(70*width/100, 35*height/100,  6*width/100, 10*height/100);
  th[4]->resize(20*width/100, 85*height/100,  6*width/100, 10*height/100);
  th[5]->resize(45*width/100, 65*height/100, 10*width/100, 20*height/100);

  layout_dirty = false;
  dirty = true;
}

void hotspot_demo_window::draw_dirty()
{
  clear(GREY0);

  multiwindow::draw_dirty();

  point p0(0,0);
  point p1(width-1, 0);
  point p2(width-1, height-1);
  point p3(0, height-1);

  draw_line_vertical(p1, p2, GREY7);
  draw_line_vertical(p0, p3, GREY7);
  draw_line_horizontal(p0, p1, GREY7);
  draw_line_horizontal(p2, p3, GREY7);
  
  set_text_size(height/25);

  static bool init = true;

  static multilingua hotspot_demo_window;
  if(init)
    {
      hotspot_demo_window.set_text("Hotspot Demo", ENGLISH);
      hotspot_demo_window.set_text(U"Hotspot 演示", CHINESE_SIMPLE);
      hotspot_demo_window.set_text(U"Hotspot 示範", CHINESE);
      hotspot_demo_window.set_text(U"Hotspot डेमो", HINDI);
      hotspot_demo_window.set_text(U"Hotspot manifestación", SPANISH);
      hotspot_demo_window.set_text(U"Hotspot démo", FRENCH);
      hotspot_demo_window.set_text(U"Hotspot عرض توضيحي", ARABIC);
      hotspot_demo_window.set_text(U"Hotspot ডেমো", BENGALI);
      hotspot_demo_window.set_text(U"Hotspot демоверсія", UKRANIAN);
      hotspot_demo_window.set_text(U"Hotspot demonstração", PORTUGUESE);
      hotspot_demo_window.set_text(U"Hotspot ڈیمو", URDU);
      hotspot_demo_window.set_text(U"Hotspot demo", INDONESIAN);
      hotspot_demo_window.set_text(U"Hotspot Demo", GERMAN);
      hotspot_demo_window.set_text(U"Hotspot デモ", JAPANESE);
      hotspot_demo_window.set_text(U"Hotspot διαδήλωση", GREEK);
      hotspot_demo_window.set_text(U"Hotspot dimostrazione", ITALIAN);
      hotspot_demo_window.set_text(U"Hotspot демо", RUSSIAN);
      hotspot_demo_window.set_text(U"Hotspot הַדגָמָה", HEBREW);
    }
  
  draw_text(hotspot_demo_window,
	    WHITE,
	    width/2,
	    height*1/20,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  set_text_size(height/50);

  color c = GREY5;
  static multilingua txt1;
  if(init)
    {
      txt1.set_text("'Hotspots' are scattered around this window.", ENGLISH);
      txt1.set_text(U"这个窗口周围散布着一些“热点”。", CHINESE_SIMPLE);
      txt1.set_text(U"窗口周圍散佈著一些“熱點”。", CHINESE);
      txt1.set_text(U"इस विंडो के चारों ओर 'हॉटस्पॉट' बिखरे हुए हैं।", HINDI);
      txt1.set_text(U"Hay \"puntos calientes\" dispersos por esta ventana.", SPANISH);
      txt1.set_text(U"Des zones sensibles sont disséminées autour de cette fenêtre.", FRENCH);
      txt1.set_text(U"تنتشر \"النقاط الساخنة\" في جميع أنحاء هذه النافذة.", ARABIC);
      txt1.set_text(U"এই জানালাটির চারপাশে ‘হটস্পটগুলো’ ছড়িয়ে ছিটিয়ে আছে।", BENGALI);
      txt1.set_text(U"«Гарячі точки» розкидані навколо цього вікна.", UKRANIAN);
      txt1.set_text(U"Existem 'pontos de acesso' espalhados à volta desta janela.", PORTUGUESE);
      txt1.set_text(U"'ہاٹ سپاٹ' اس کھڑکی کے ارد گرد بکھرے ہوئے ہیں۔", URDU);
      txt1.set_text(U"\"Titik-titik panas\" tersebar di sekitar jendela ini.", INDONESIAN);
      txt1.set_text(U"In diesem Fenster sind an verschiedenen Stellen „Hotspots“ verteilt.", GERMAN);
      txt1.set_text(U"このウィンドウには「ホットスポット」が点在している。", JAPANESE);
      txt1.set_text(U"«Hotspots» είναι διάσπαρτα γύρω από αυτό το παράθυρο.", GREEK);
      txt1.set_text(U"In questa finestra sono presenti diversi \"punti critici\".", ITALIAN);
      txt1.set_text(U"В этом окне разбросаны «горячие точки».", RUSSIAN);
      txt1.set_text(U"'נקודות חמות' פזורות סביב חלון זה.", HEBREW);
    }
  
  draw_text(txt1,
	    c,
	    width/2,
	    height*3/20,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua txt2;
  if(init)
    {
      txt2.set_text("Hotspots are invisible areas that accept input events.", ENGLISH);
      txt2.set_text(U"热点是指接受输入事件的不可见区域。", CHINESE_SIMPLE);
      txt2.set_text(U"熱點是接受輸入事件的不可見區域。", CHINESE);
      txt2.set_text(U"हॉटस्पॉट ऐसे अदृश्य क्षेत्र होते हैं जो इनपुट इवेंट स्वीकार करते हैं।", HINDI);
      txt2.set_text(U"Los puntos de acceso son áreas invisibles que aceptan eventos de entrada.", SPANISH);
      txt2.set_text(U"Les zones interactives sont des zones invisibles qui acceptent les événements d'entrée.", FRENCH);
      txt2.set_text(U"المناطق الساخنة هي مناطق غير مرئية تقبل أحداث الإدخال.", ARABIC);
      txt2.set_text(U"হটস্পট হলো অদৃশ্য এলাকা যা ইনপুট ইভেন্ট গ্রহণ করে।", BENGALI);
      txt2.set_text(U"Гарячі точки – це невидимі області, які приймають вхідні події.", UKRANIAN);
      txt2.set_text(U"Os hotspots são áreas invisíveis que aceitam eventos de entrada.", PORTUGUESE);
      txt2.set_text(U"ہاٹ سپاٹ پوشیدہ علاقے ہیں جو ان پٹ واقعات کو قبول کرتے ہیں۔", URDU);
      txt2.set_text(U"Hotspot adalah area tak terlihat yang menerima peristiwa input.", INDONESIAN);
      txt2.set_text(U"Hotspots sind unsichtbare Bereiche, die Eingabeereignisse empfangen.", GERMAN);
      txt2.set_text(U"ホットスポットとは、入力イベントを受け付ける目に見えない領域のことです。", JAPANESE);
      txt2.set_text(U"Τα hotspots είναι αόρατες περιοχές που δέχονται συμβάντα εισόδου.", GREEK);
      txt2.set_text(U"Gli hotspot sono aree invisibili che recepiscono gli eventi di input.", ITALIAN);
      txt2.set_text(U"Активные области — это невидимые области, которые принимают входные события.", RUSSIAN);
      txt2.set_text(U"נקודות חמות הן אזורים בלתי נראים המקבלים אירועי קלט.", HEBREW);
    }
  draw_text(txt2,
	    c,
	    width/2,
	    height*32/80,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua txt3;
  if(init)
    {
      txt3.set_text("These hotspots have been modified so that", ENGLISH);
      txt3.set_text(U"这些热点区域已被修改，以便：", CHINESE_SIMPLE);
      txt3.set_text(U"這些熱點區域已被修改，以便：", CHINESE);
      txt3.set_text(U"इन हॉटस्पॉट को बदला गया है ताकि", HINDI);
      txt3.set_text(U"Estos puntos de acceso se han modificado para que", SPANISH);
      txt3.set_text(U"Ces points d'accès ont été modifiés de sorte que", FRENCH);
      txt3.set_text(U"تم تعديل هذه النقاط الساخنة بحيث", ARABIC);
      txt3.set_text(U"এই হটস্পটগুলি এমনভাবে পরিবর্তন করা হয়েছে যাতে", BENGALI);
      txt3.set_text(U"Ці гарячі точки були змінені таким чином, щоб", UKRANIAN);
      txt3.set_text(U"Estes pontos críticos foram modificados para que", PORTUGUESE);
      txt3.set_text(U"ان ہاٹ سپاٹ کو اس لیے تبدیل کیا گیا ہے۔", URDU);
      txt3.set_text(U"Hotspot ini telah dimodifikasi sehingga", INDONESIAN);
      txt3.set_text(U"Diese Hotspots wurden so verändert, dass", GERMAN);
      txt3.set_text(U"これらのホットスポットは、", JAPANESE);
      txt3.set_text(U"Αυτά τα hotspots έχουν τροποποιηθεί έτσι ώστε", GREEK);
      txt3.set_text(U"Questi hotspot sono stati modificati in modo che", ITALIAN);
      txt3.set_text(U"Эти точки доступа были изменены таким образом, что", RUSSIAN);
      txt3.set_text(U"נקודות חמות אלו שונו כך ש", HEBREW);
    }
  draw_text(txt3,
	    c,
	    width/2,
	    height*40/80,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua txt4;
  if(init)
    {
      txt4.set_text("their visibility toggles as they are clicked.", ENGLISH);
      txt4.set_text(U"点击它们时，它们的可见性会切换。", CHINESE_SIMPLE);
      txt4.set_text(U"點擊它們即可切換其可見性。", CHINESE);
      txt4.set_text(U"क्लिक करने पर उनकी विज़िबिलिटी टॉगल होती है।", HINDI);
      txt4.set_text(U"Su visibilidad cambia al hacer clic sobre ellos.", SPANISH);
      txt4.set_text(U"Leur visibilité change lorsqu'on clique dessus.", FRENCH);
      txt4.set_text(U"يتم تبديل ظهورها عند النقر عليها.", ARABIC);
      txt4.set_text(U"সেগুলোতে ক্লিক করলে সেগুলোর দৃশ্যমানতা পরিবর্তিত হয়।", BENGALI);
      txt4.set_text(U"їхня видимість змінюється при натисканні.", UKRANIAN);
      txt4.set_text(U"A visibilidade dos mesmos alterna conforme são clicados.", PORTUGUESE);
      txt4.set_text(U"ان پر کلک کرتے ہی ان کی مرئیت ٹوگل ہوجاتی ہے۔", URDU);
      txt4.set_text(U"Visibilitasnya beralih setiap kali diklik.", INDONESIAN);
      txt4.set_text(U"Ihre Sichtbarkeit ändert sich, wenn man darauf klickt.", GERMAN);
      txt4.set_text(U"それらはクリックされるたびに表示・非表示が切り替わります。", JAPANESE);
      txt4.set_text(U"Η ορατότητά τους εναλλάσσεται καθώς γίνεται κλικ σε αυτά.", GREEK);
      txt4.set_text(U"La loro visibilità cambia ogni volta che vengono cliccati.", ITALIAN);
      txt4.set_text(U"Их видимость переключается при каждом щелчке мышью.", RUSSIAN);
      txt4.set_text(U"הנראות שלהם משתנה בעת לחיצה עליהם.", HEBREW);
    }
  draw_text(txt4,
	    c,
	    width/2,
	    height*43/80,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);


  init = false;
}

