
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "kiosk/window.hh"
#include "kiosk/multiwindow.hh"
#include "kiosk/select_one.hh"
#include "kiosk/unalingua.hh"

#include "select_one_demo.hh"
#include "languages.hh"

void s1d_selection_changed_function(selection_changed_event* sce, class multiselect* ms, void* data);


class select_one_demo_window : public multiwindow
{
  select_one* ms;

  int             NUM_FAVS;
  multilingua*    favorite_colors;
  dt_colors       fav_colors;

  virtual void layout();
  virtual void draw_dirty();
  virtual void draw_dynamic();

public:

  const static int text_display_interval    = 100;
  unalingua        last_text;
  int              last_text_count;

  select_one_demo_window();
  ~select_one_demo_window();
};

window* create_select_one_demo_window()
{
  return new select_one_demo_window();
}


select_one_demo_window::~select_one_demo_window()
{
}

select_one_demo_window::select_one_demo_window()
{
  last_text_count    = 0;
  
  color bg           = BLACK;

  multilingua title;

  title.set_text("Select_One", ENGLISH);

#ifdef NOTDEF
  title.set_text(U"", CHINESE_SIMPLE);
  title.set_text(U"", CHINESE);
  title.set_text(U"", HINDI);
  title.set_text(U"", SPANISH);
  title.set_text(U"", FRENCH);
  title.set_text(U"", ARABIC);
  title.set_text(U"", BENGALI);
  title.set_text(U"", UKRANIAN);
  title.set_text(U"", PORTUGUESE);
  title.set_text(U"", URDU);
  title.set_text(U"", INDONESIAN);
  title.set_text(U"", GERMAN);
  title.set_text(U"", JAPANESE);
  title.set_text(U"", GREEK);
  title.set_text(U"", ITALIAN);
  title.set_text(U"", RUSSIAN);
  title.set_text(U"", HEBREW);
#endif
  
  NUM_FAVS = 6;

  favorite_colors = new multilingua[NUM_FAVS];
  
  favorite_colors[0].set_text("Red", ENGLISH);
  favorite_colors[0].set_text(U"红色的", CHINESE_SIMPLE);
  favorite_colors[0].set_text(U"紅色的", CHINESE);
  favorite_colors[0].set_text(U"लाल", HINDI);
  favorite_colors[0].set_text(U"Roja", SPANISH);
  favorite_colors[0].set_text(U"Rouge", FRENCH);
  favorite_colors[0].set_text(U"أحمر", ARABIC);
  favorite_colors[0].set_text(U"লাল", BENGALI);
  favorite_colors[0].set_text(U"Червоний", UKRANIAN);
  favorite_colors[0].set_text(U"Vermelha", PORTUGUESE);
  favorite_colors[0].set_text(U"سرخ", URDU);
  favorite_colors[0].set_text(U"Merah", INDONESIAN);
  favorite_colors[0].set_text(U"Rot", GERMAN);
  favorite_colors[0].set_text(U"赤", JAPANESE);
  favorite_colors[0].set_text(U"Κόκκινος", GREEK);
  favorite_colors[0].set_text(U"Rossa", ITALIAN);
  favorite_colors[0].set_text(U"Красный", RUSSIAN);
  favorite_colors[0].set_text(U"אָדוֹם", HEBREW);
      
  favorite_colors[1].set_text("Green", ENGLISH);
  favorite_colors[1].set_text(U"绿色的", CHINESE_SIMPLE);
  favorite_colors[1].set_text(U"綠色的", CHINESE);
  favorite_colors[1].set_text(U"हरा", HINDI);
  favorite_colors[1].set_text(U"Verde", SPANISH);
  favorite_colors[1].set_text(U"Verte", FRENCH);
  favorite_colors[1].set_text(U"أخضر", ARABIC);
  favorite_colors[1].set_text(U"সবুজ", BENGALI);
  favorite_colors[1].set_text(U"Зелений", UKRANIAN);
  favorite_colors[1].set_text(U"Verde", PORTUGUESE);
  favorite_colors[1].set_text(U"سبز", URDU);
  favorite_colors[1].set_text(U"Hijau", INDONESIAN);
  favorite_colors[1].set_text(U"Grün", GERMAN);
  favorite_colors[1].set_text(U"緑", JAPANESE);
  favorite_colors[1].set_text(U"Πράσινος", GREEK);
  favorite_colors[1].set_text(U"Verde", ITALIAN);
  favorite_colors[1].set_text(U"Зеленый", RUSSIAN);
  favorite_colors[1].set_text(U"יָרוֹק", HEBREW);
  
  favorite_colors[2].set_text("Blue", ENGLISH);
  favorite_colors[2].set_text(U"蓝色的", CHINESE_SIMPLE);
  favorite_colors[2].set_text(U"藍色的", CHINESE);
  favorite_colors[2].set_text(U"नीला", HINDI);
  favorite_colors[2].set_text(U"Azul", SPANISH);
  favorite_colors[2].set_text(U"Bleue", FRENCH);
  favorite_colors[2].set_text(U"أزرق", ARABIC);
  favorite_colors[2].set_text(U"নীল", BENGALI);
  favorite_colors[2].set_text(U"Синій", UKRANIAN);
  favorite_colors[2].set_text(U"Azul", PORTUGUESE);
  favorite_colors[2].set_text(U"نیلا", URDU);
  favorite_colors[2].set_text(U"Biru", INDONESIAN);
  favorite_colors[2].set_text(U"Blau", GERMAN);
  favorite_colors[2].set_text(U"青", JAPANESE);
  favorite_colors[2].set_text(U"Μπλε", GREEK);
  favorite_colors[2].set_text(U"Blu", ITALIAN);
  favorite_colors[2].set_text(U"Синий", RUSSIAN);
  favorite_colors[2].set_text(U"כְּחוֹל", HEBREW);
  
  favorite_colors[3].set_text("Yellow", ENGLISH);
  favorite_colors[3].set_text(U"黄色的", CHINESE_SIMPLE);
  favorite_colors[3].set_text(U"黃色的", CHINESE);
  favorite_colors[3].set_text(U"पीला", HINDI);
  favorite_colors[3].set_text(U"Amarilla", SPANISH);
  favorite_colors[3].set_text(U"Jaune", FRENCH);
  favorite_colors[3].set_text(U"أصفر", ARABIC);
  favorite_colors[3].set_text(U"হলুদ", BENGALI);
  favorite_colors[3].set_text(U"Жовтий", UKRANIAN);
  favorite_colors[3].set_text(U"Amarela", PORTUGUESE);
  favorite_colors[3].set_text(U"پیلا", URDU);
  favorite_colors[3].set_text(U"Kuning", INDONESIAN);
  favorite_colors[3].set_text(U"Gelb", GERMAN);
  favorite_colors[3].set_text(U"黄色", JAPANESE);
  favorite_colors[3].set_text(U"Κίτρινος", GREEK);
  favorite_colors[3].set_text(U"Gialla", ITALIAN);
  favorite_colors[3].set_text(U"Желтый", RUSSIAN);
  favorite_colors[3].set_text(U"צָהוֹב", HEBREW);
  
  favorite_colors[4].set_text("Orange", ENGLISH);
  favorite_colors[4].set_text(U"橙子", CHINESE_SIMPLE);
  favorite_colors[4].set_text(U"橘子", CHINESE);
  favorite_colors[4].set_text(U"नारंगी", HINDI);
  favorite_colors[4].set_text(U"Naranja", SPANISH);
  favorite_colors[4].set_text(U"Orange", FRENCH);
  favorite_colors[4].set_text(U"البرتقالي", ARABIC);
  favorite_colors[4].set_text(U"কমলা", BENGALI);
  favorite_colors[4].set_text(U"Помаранчевий", UKRANIAN);
  favorite_colors[4].set_text(U"Laranja", PORTUGUESE);
  favorite_colors[4].set_text(U"کینو", URDU);
  favorite_colors[4].set_text(U"Oranye", INDONESIAN);
  favorite_colors[4].set_text(U"Orange", GERMAN);
  favorite_colors[4].set_text(U"オレンジ", JAPANESE);
  favorite_colors[4].set_text(U"Πορτοκάλι", GREEK);
  favorite_colors[4].set_text(U"Arancia", ITALIAN);
  favorite_colors[4].set_text(U"Апельсин", RUSSIAN);
  favorite_colors[4].set_text(U"כָּתוֹם", HEBREW);
  
  favorite_colors[5].set_text("Purple", ENGLISH);
  favorite_colors[5].set_text(U"紫色的", CHINESE_SIMPLE);
  favorite_colors[5].set_text(U"紫色的", CHINESE);
  favorite_colors[5].set_text(U"बैंगनी", HINDI);
  favorite_colors[5].set_text(U"Púrpura", SPANISH);
  favorite_colors[5].set_text(U"Violette", FRENCH);
  favorite_colors[5].set_text(U"أرجواني", ARABIC);
  favorite_colors[5].set_text(U"বেগুনি", BENGALI);
  favorite_colors[5].set_text(U"Фіолетовий", UKRANIAN);
  favorite_colors[5].set_text(U"Roxa", PORTUGUESE);
  favorite_colors[5].set_text(U"جامنی", URDU);
  favorite_colors[5].set_text(U"Ungu", INDONESIAN);
  favorite_colors[5].set_text(U"Lila", GERMAN);
  favorite_colors[5].set_text(U"紫", JAPANESE);
  favorite_colors[5].set_text(U"Μωβ", GREEK);
  favorite_colors[5].set_text(U"Viola", ITALIAN);
  favorite_colors[5].set_text(U"Фиолетовый", RUSSIAN);
  favorite_colors[5].set_text(U"סָגוֹל", HEBREW);

  ms = new select_one(title, bg);

  multilingua txt;
  

  dt_colors fcolors = { WHITE, RED, GREEN, BLUE, YELLOW, ORANGE, PURPLE };
  fav_colors = fcolors;

  for(int i=0; i<NUM_FAVS; i++)
    {
      ms->add(favorite_colors[i], false /*start_selected*/, false /* disabled */ );
      ms->set_text_color(i, fcolors.c[i+1]);
      ms->set_selected_text_color(i, BLACK);
      ms->set_selected_highlight_color(i, fcolors.c[i+1]);
    }

  ms->change_function      = s1d_selection_changed_function;
  ms->change_function_data = this;

  
  add(ms);
}


void s1d_selection_changed_function(selection_changed_event* sce, class multiselect* ms, void* data)
{
  select_one_demo_window* mdw = (select_one_demo_window*) data;
  mdw->last_text_count = mdw->text_display_interval;

  char tmp[2];
  tmp[0] = 10+sce->selection_number+1;  // A color selection for draw_multicolored_text
  tmp[1] = 0;

  static bool init = true;
  static multilingua selected;
  if(init)
    {
      selected.set_text("selected", ENGLISH);
      selected.set_text(U"已选择", CHINESE_SIMPLE);
      selected.set_text(U"已選", CHINESE);
      selected.set_text(U"चयनित", HINDI);
      selected.set_text(U"seleccionado", SPANISH);
      selected.set_text(U"choisi", FRENCH);
      selected.set_text(U"مختار", ARABIC);
      selected.set_text(U"নির্বাচিত", BENGALI);
      selected.set_text(U"вибраний", UKRANIAN);
      selected.set_text(U"selecionado", PORTUGUESE);
      selected.set_text(U"منتخب", URDU);
      selected.set_text(U"terpilih", INDONESIAN);
      selected.set_text(U"ausgewählt", GERMAN);
      selected.set_text(U"選択済み", JAPANESE);
      selected.set_text(U"επιλεγμένο", GREEK);
      selected.set_text(U"selezionato", ITALIAN);
      selected.set_text(U"выбранный", RUSSIAN);
      selected.set_text(U"נִבחָר", HEBREW);
    }

  unalingua txt = tmp;
  txt.append_text(sce->selection_name);
  txt.append_text(DT_COLOR_0 " ");
  txt.append_text(selected);
  
  mdw->last_text = txt;
  init = false;
}


void select_one_demo_window::layout()
{
  //b->resize(20*width/100, 60*height/100, 60*width/100, 20*height/100);
  ms->resize(width/10, height/10, 9*width/10, 9*height/10);
  ms->layout();

  layout_dirty = false;
  dirty = true;
}

void select_one_demo_window::draw_dynamic()
{
  if(last_text_count)
    {
      last_text_count--;

      dt_colors draw_colors;
          
      for(int i=0; i<MAX_COLORS; i++)
        draw_colors.c[i] = scale(fav_colors.c[i], BLACK, last_text_count / (float) text_display_interval);
      
      set_text_size(height/25);

      //draw_line(point(0, height*60/100), point(width-1, height*60/100), RED);
      
      draw_multicolored_text(last_text.get_text(),
                             0,
                             draw_colors,
                             6*width/10,
                             height*20/100,
                             DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
    }

  multiwindow::draw_dynamic();
}

void select_one_demo_window::draw_dirty()
{
  multiwindow::draw_dirty();
    
  point p0(0,0);
  point p1(width-1, 0);
  point p2(width-1, height-1);
  point p3(0, height-1);

  draw_line_vertical(p1, p2, GREY7);
  draw_line_vertical(p0, p3, GREY7);
  draw_line_horizontal(p0, p1, GREY7);
  draw_line_horizontal(p2, p3, GREY7);
  
  set_text_size(height/25);

  static bool init = true;

  static multilingua select_one_demo;
  if(init)
    {
      select_one_demo.set_text("Select_One Demo", ENGLISH);
      select_one_demo.set_text(U"Select_One 演示", CHINESE_SIMPLE);
      select_one_demo.set_text(U"Select_One 示範", CHINESE);
      select_one_demo.set_text(U"Select_One डेमो", HINDI);
      select_one_demo.set_text(U"Select_One manifestación", SPANISH);
      select_one_demo.set_text(U"Select_One démo", FRENCH);
      select_one_demo.set_text(U"Select_One عرض توضيحي", ARABIC);
      select_one_demo.set_text(U"Select_One ডেমো", BENGALI);
      select_one_demo.set_text(U"Select_One демоверсія", UKRANIAN);
      select_one_demo.set_text(U"Select_One demonstração", PORTUGUESE);
      select_one_demo.set_text(U"Select_One ڈیمو", URDU);
      select_one_demo.set_text(U"Select_One demo", INDONESIAN);
      select_one_demo.set_text(U"Select_One Demo", GERMAN);
      select_one_demo.set_text(U"Select_One デモ", JAPANESE);
      select_one_demo.set_text(U"Select_One διαδήλωση", GREEK);
      select_one_demo.set_text(U"Select_One dimostrazione", ITALIAN);
      select_one_demo.set_text(U"Select_One демо", RUSSIAN);
      select_one_demo.set_text(U"Select_One הַדגָמָה", HEBREW);
    }
  
  draw_text(select_one_demo,
	    WHITE,
	    width/2,
	    height*1/20,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  set_text_size(height/50);

  color c = GREY5;
  static multilingua txt1;
  if(init)
    {
      txt1.set_text("Select single items with a select_one control.", ENGLISH);
      txt1.set_text(U"使用 select_one 控件选择单个项目。", CHINESE_SIMPLE);
      txt1.set_text(U"使用 select_one 控制項選擇單一項目。", CHINESE);
      txt1.set_text(U"select_one कंट्रोल से सिंगल आइटम चुनें।", HINDI);
      txt1.set_text(U"Seleccione elementos individuales con un control select_one.", SPANISH);
      txt1.set_text(U"Sélectionnez des éléments individuels à l'aide d'un contrôle select_one.", FRENCH);
      txt1.set_text(U"حدد عناصر مفردة باستخدام أداة التحكم select_one.", ARABIC);
      txt1.set_text(U"select_one কন্ট্রোল ব্যবহার করে একক আইটেম নির্বাচন করুন।", BENGALI);
      txt1.set_text(U"Вибір окремих елементів за допомогою елемента керування select_one.", UKRANIAN);
      txt1.set_text(U"Selecione itens individuais com um controlo select_one.", PORTUGUESE);
      txt1.set_text(U"سلیکٹ_ون کنٹرول کے ساتھ واحد آئٹمز منتخب کریں۔", URDU);
      txt1.set_text(U"Pilih satu item menggunakan kontrol select_one.", INDONESIAN);
      txt1.set_text(U"Wählen Sie einzelne Elemente mit einem select_one-Steuerelement aus.", GERMAN);
      txt1.set_text(U"select_oneコントロールを使用して、単一の項目を選択します。", JAPANESE);
      txt1.set_text(U"Επιλέξτε μεμονωμένα στοιχεία με ένα στοιχείο ελέγχου select_one.", GREEK);
      txt1.set_text(U"Seleziona singoli elementi con un controllo select_one.", ITALIAN);
      txt1.set_text(U"Выбирайте отдельные элементы с помощью элемента управления select_one.", RUSSIAN);
      txt1.set_text(U"בחר פריטים בודדים באמצעות פקד select_one.", HEBREW);
    }
  
  draw_text(txt1,
	    c,
	    width/2,
	    height*20/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);


  static multilingua txt1a;
  if(init)
    {
      txt1a.set_text("Use 'multiselect' instead for multiple selections.", ENGLISH);
      txt1a.set_text(U"对于多项选择，请使用“multiselect”选项。", CHINESE_SIMPLE);
      txt1a.set_text(U"對於多項選擇，請使用“多選”功能。", CHINESE);
      txt1a.set_text(U"कई सेलेक्शन के लिए इसके बजाय 'मल्टीसेलेक्ट' का इस्तेमाल करें।", HINDI);
      txt1a.set_text(U"Utilice la opción \"multiselect\" en su lugar para seleccionar varios elementos.", SPANISH);
      txt1a.set_text(U"Utilisez plutôt l'option « multiselect » pour les sélections multiples.", FRENCH);
      txt1a.set_text(U"استخدم \"multiselect\" بدلاً من ذلك لتحديد خيارات متعددة.", ARABIC);
      txt1a.set_text(U"একাধিক নির্বাচনের জন্য পরিবর্তে 'মাল্টিসিলেক্ট' ব্যবহার করুন।", BENGALI);
      txt1a.set_text(U"Для кількох варіантів вибору використовуйте «мультиселект».", UKRANIAN);
      txt1a.set_text(U"Utilize 'multiselect' em vez disso para seleções múltiplas.", PORTUGUESE);
      txt1a.set_text(U"متعدد انتخاب کے لیے 'ملٹی سلیکٹ' استعمال کریں۔", URDU);
      txt1a.set_text(U"Gunakan 'multiselect' sebagai gantinya untuk pemilihan berganda.", INDONESIAN);
      txt1a.set_text(U"Verwenden Sie stattdessen „Multiselect“ für Mehrfachauswahlen.", GERMAN);
      txt1a.set_text(U"複数の項目を選択する場合は、「multiselect」を使用してください。", JAPANESE);
      txt1a.set_text(U"Χρησιμοποιήστε την επιλογή «πολλαπλή επιλογή» για πολλαπλές επιλογές.", GREEK);
      txt1a.set_text(U"Utilizzare l'opzione \"multiselect\" per selezionare più elementi contemporaneamente.", ITALIAN);
      txt1a.set_text(U"Для выбора нескольких элементов используйте параметр «multiselect».", RUSSIAN);
      txt1a.set_text(U"השתמשו באפשרות 'בחירה מרובה' במקום זאת עבור בחירות מרובות.", HEBREW);
    }
  
  draw_text(txt1a,
	    c,
	    width/2,
	    height*22/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  
  static multilingua txt2;
  if(init)
    {
      txt2.set_text("Use 'ask_selection' instead for less screen area.", ENGLISH);
      txt2.set_text(U"为了节省屏幕空间，请改用“ask_selection”。", CHINESE_SIMPLE);
      txt2.set_text(U"如果螢幕佔用空間較小，請使用「ask_selection」取代。", CHINESE);
      txt2.set_text(U"कम स्क्रीन एरिया के लिए इसके बजाय 'ask_selection' का इस्तेमाल करें।", HINDI);
      txt2.set_text(U"Utilice 'ask_selection' en su lugar para ocupar menos espacio en la pantalla.", SPANISH);
      txt2.set_text(U"Utilisez plutôt « ask_selection » pour un affichage occupant moins d'espace à l'écran.", FRENCH);
      txt2.set_text(U"استخدم \"ask_selection\" بدلاً من ذلك لتوفير مساحة أكبر على الشاشة.", ARABIC);
      txt2.set_text(U"কম স্ক্রিন জায়গার জন্য এর পরিবর্তে 'ask_selection' ব্যবহার করুন।", BENGALI);
      txt2.set_text(U"Використовуйте 'ask_selection' для меншої площі екрана.", UKRANIAN);
      txt2.set_text(U"Utilize 'ask_selection' em vez disso para ocupar menos espaço no ecrã.", PORTUGUESE);
      txt2.set_text(U"اس کے بجائے کم اسکرین ایریا کے لیے 'ask_selection' استعمال کریں۔", URDU);
      txt2.set_text(U"Gunakan 'ask_selection' sebagai gantinya untuk menghemat ruang layar.", INDONESIAN);
      txt2.set_text(U"Verwenden Sie stattdessen „ask_selection“, um weniger Bildschirmfläche zu beanspruchen.", GERMAN);
      txt2.set_text(U"画面スペースを節約するには、「ask_selection」を使用してください。", JAPANESE);
      txt2.set_text(U"Χρησιμοποιήστε το 'ask_selection' για μικρότερη περιοχή οθόνης.", GREEK);
      txt2.set_text(U"Utilizzare 'ask_selection' al posto di questa opzione per occupare meno spazio sullo schermo.", ITALIAN);
      txt2.set_text(U"Для экономии места на экране используйте функцию «ask_selection».", RUSSIAN);
      txt2.set_text(U"השתמש ב-'ask_selection' במקום זאת עבור שטח מסך קטן יותר.", HEBREW);
    }
  draw_text(txt2,
	    c,
	    width/2,
	    height*24/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua txt3;
  if(init)
    {
      txt3.set_text("Select_one always displays the choices.", ENGLISH);
      txt3.set_text(U"Select_one 始终显示所有选项。", CHINESE_SIMPLE);
      txt3.set_text(U"Select_one 始終顯示選項。", CHINESE);
      txt3.set_text(U"Select_one हमेशा विकल्प दिखाता है।", HINDI);
      txt3.set_text(U"Select_one siempre muestra las opciones.", SPANISH);
      txt3.set_text(U"Select_one affiche toujours les options.", FRENCH);
      txt3.set_text(U"تُظهر وظيفة \"Select_one\" الخيارات دائمًا.", ARABIC);
      txt3.set_text(U"\"Select_one\" সর্বদা পছন্দগুলো প্রদর্শন করে।", BENGALI);
      txt3.set_text(U"Select_one завжди відображає варіанти.", UKRANIAN);
      txt3.set_text(U"O Select_one apresenta sempre as opções.", PORTUGUESE);
      txt3.set_text(U"Select_one ہمیشہ انتخاب دکھاتا ہے۔", URDU);
      txt3.set_text(U"Select_one selalu menampilkan pilihan-pilihan yang tersedia.", INDONESIAN);
      txt3.set_text(U"Select_one zeigt immer die Auswahlmöglichkeiten an.", GERMAN);
      txt3.set_text(U"Select_one は常に選択肢を表示します。", JAPANESE);
      txt3.set_text(U"Η συνάρτηση Select_one εμφανίζει πάντα τις επιλογές.", GREEK);
      txt3.set_text(U"Select_one visualizza sempre le opzioni disponibili.", ITALIAN);
      txt3.set_text(U"Элемент Select_one всегда отображает варианты выбора.", RUSSIAN);
      txt3.set_text(U"הפונקציה Select_one תמיד מציגה את האפשרויות.", HEBREW);
    }
  draw_text(txt3,
	    c,
	    width/2,
	    height*26/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua txt4;
  if(init)
    {
      txt4.set_text("A selection change generates an action.", ENGLISH);
      txt4.set_text(U"变化会引发行动。", CHINESE_SIMPLE);
      txt4.set_text(U"改變會引發行動。", CHINESE);
      txt4.set_text(U"एक बदलाव एक एक्शन को जन्म देता है।", HINDI);
      txt4.set_text(U"Un cambio genera una acción.", SPANISH);
      txt4.set_text(U"Un changement génère une action.", FRENCH);
      txt4.set_text(U"التغيير يولد فعلاً.", ARABIC);
      txt4.set_text(U"একটি পরিবর্তন একটি কাজের জন্ম দেয়।", BENGALI);
      txt4.set_text(U"Зміна породжує дію.", UKRANIAN);
      txt4.set_text(U"Uma mudança gera uma ação.", PORTUGUESE);
      txt4.set_text(U"ایک تبدیلی ایک عمل پیدا کرتی ہے۔", URDU);
      txt4.set_text(U"Perubahan akan menghasilkan suatu tindakan.", INDONESIAN);
      txt4.set_text(U"Eine Veränderung löst eine Handlung aus.", GERMAN);
      txt4.set_text(U"変化は行動を生み出す。", JAPANESE);
      txt4.set_text(U"Μια αλλαγή γεννά μια δράση.", GREEK);
      txt4.set_text(U"Un cambiamento genera un'azione.", ITALIAN);
      txt4.set_text(U"Изменение порождает действие.", RUSSIAN);
      txt4.set_text(U"שינוי מייצר פעולה.", HEBREW);
    }
  draw_text(txt4,
	    c,
	    width/2,
	    height*28/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  init = false;
}


